% objective: find the confidence interval of exch
% Author: Xueyang Feng (fengx@seas.wustl.edu)
% date: 09/01/2011

clear
clc

global var
var=xlsread('dynamicFlux.xlsx');

 
exch_seg1=[0.861857561740551;0.269814011526529;0.109205419205674;0.944400024392201;];
[f_seg1,exIDV_Ala_seg1,exIDV_Ser_seg1,exIDV_Gly_seg1,exIDV_Asp_seg1,exIDV_Glu_seg1]=final_13C_dFBA(var,exch_seg1);


MDV_Ala_Early=[0.0685000000000000;0.904700000000000;0.0248000000000000;0.00200000000000000;];
MDV_Ser_Early=[0.151600000000000;0.655100000000000;0.148900000000000;0.0444000000000000;];
MDV_Asp_Early=[0.0724000000000000;0.234300000000000;0.372900000000000;0.312500000000000;0.00790000000000000;];
MDV_Glu_Early=[0.0542000000000000;0.0131000000000000;0.326900000000000;0.436500000000000;0.166500000000000;0.00280000000000000;];
MDV_Gly_Early=[0.627700000000000;0.286800000000000;0.0855000000000000;];

MDV_Ala_Late=[0.0642000000000000;0.834100000000000;0.0696000000000000;0.0321000000000000;];
MDV_Ser_Late=[0.128000000000000;0.586800000000000;0.205800000000000;0.0794000000000000;];
MDV_Asp_Late=[0.0552000000000000;0.193000000000000;0.349900000000000;0.379500000000000;0.0223000000000000;];
MDV_Glu_Late=[0.0420000000000000;0.0108000000000000;0.257300000000000;0.470200000000000;0.218300000000000;0.00130000000000000;];
MDV_Gly_Late=[0.525500000000000;0.334200000000000;0.140300000000000;];

n=length(MDV_Ala_Early)+length(MDV_Ser_Early)+length(MDV_Asp_Early)+length(MDV_Glu_Early)+length(MDV_Gly_Early)+...
  length(MDV_Ala_Late)+length(MDV_Ser_Late)+length(MDV_Asp_Late)+length(MDV_Glu_Late)+length(MDV_Gly_Late);  

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
time_early=288;
time_late=336;

beta=exch_seg1';

resids_Ala_Early=MDV_Ala_Early-exIDV_Ala_seg1(:,time_early);
resids_Ser_Early=MDV_Ser_Early-exIDV_Ser_seg1(:,time_early);
resids_Asp_Early=MDV_Asp_Early-exIDV_Asp_seg1(:,time_early);
resids_Glu_Early=MDV_Glu_Early-exIDV_Glu_seg1(:,time_early);
resids_Gly_Early=MDV_Gly_Early-exIDV_Gly_seg1(:,time_early);
resids_Ala_Late=MDV_Ala_Late-exIDV_Ala_seg1(:,time_late);
resids_Ser_Late=MDV_Ser_Late-exIDV_Ser_seg1(:,time_late);
resids_Asp_Late=MDV_Asp_Late-exIDV_Asp_seg1(:,time_late);
resids_Glu_Late=MDV_Glu_Late-exIDV_Glu_seg1(:,time_late);
resids_Gly_Late=MDV_Gly_Late-exIDV_Gly_seg1(:,time_late);

resids=[resids_Ala_Early;resids_Ser_Early;resids_Asp_Early;resids_Glu_Early;resids_Gly_Early;resids_Ala_Late;resids_Ser_Late;resids_Asp_Late;resids_Glu_Late;resids_Gly_Late];


num_exp=44;
num_param=4;
J=zeros(num_exp,num_param);
perturb=0.001;
exch_seg1_perturb=zeros(4,1);
X=[exIDV_Ala_seg1(:,time_early);exIDV_Ser_seg1(:,time_early);exIDV_Asp_seg1(:,time_early);exIDV_Glu_seg1(:,time_early);exIDV_Gly_seg1(:,time_early);exIDV_Ala_seg1(:,time_late);exIDV_Ser_seg1(:,time_late);exIDV_Asp_seg1(:,time_late);exIDV_Glu_seg1(:,time_late);exIDV_Gly_seg1(:,time_late)];
for i=1:length(exch_seg1)
    exch_seg1_perturb=exch_seg1;
    exch_seg1_perturb(i)=exch_seg1(i)*(1+perturb);
    [f_perturb,exIDV_Ala_perturb,exIDV_Ser_perturb,exIDV_Gly_perturb,exIDV_Asp_perturb,exIDV_Glu_perturb]=final_13C_dFBA(var,exch_seg1_perturb);
    X_perturb=[exIDV_Ala_perturb(:,time_early);exIDV_Ser_perturb(:,time_early);exIDV_Asp_perturb(:,time_early);exIDV_Glu_perturb(:,time_early);exIDV_Gly_perturb(:,time_early);exIDV_Ala_perturb(:,time_late);exIDV_Ser_perturb(:,time_late);exIDV_Asp_perturb(:,time_late);exIDV_Glu_perturb(:,time_late);exIDV_Gly_perturb(:,time_late)];
    J(:,i)=(X_perturb-X)./(exch_seg1_perturb(i)-exch_seg1(i));
end

%confidence intervals for parameters
ci=nlparci(beta,resids,J);
